/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.fcs.chatlet;

import com.ibm.hwmca.fw.fcs.FcsConnection;
import com.ibm.hwmca.fw.fcs.FcsEvent;
import com.ibm.hwmca.fw.fcs.FcsEventListener;
import com.ibm.hwmca.fw.fcs.FcsException;
import com.ibm.hwmca.fw.fcs.FcsServer;
import com.ibm.hwmca.fw.fcs.FcsServiceId;
import com.ibm.hwmca.fw.fcs.MachineId;
import com.ibm.hwmca.fw.fcs.chatlet.ChatletClient;
import com.ibm.hwmca.fw.fcs.chatlet.ChatletClientPortal;
import com.ibm.hwmca.fw.fcs.chatlet.ChatletException;
import com.ibm.hwmca.fw.fcs.chatlet.ChatletMessage;
import com.ibm.hwmca.fw.fcs.chatlet.ChatletObjectFactory;
import com.ibm.hwmca.fw.fcs.chatlet.ChatletPacket;
import com.ibm.hwmca.fw.fcs.chatlet.ChatletProtocol;
import com.ibm.hwmca.fw.fcs.chatlet.ChatletRequest;
import com.ibm.hwmca.fw.fcs.chatlet.ChatletRequestTimeoutException;
import com.ibm.hwmca.fw.fcs.chatlet.ChatletResponse;
import com.ibm.hwmca.fw.util.Trace;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.Socket;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public final class ChatletClientManager
implements ChatletProtocol {
    private static final String TRACE_MASKF = "XFCS-CMF";
    private static final Map clients = new HashMap();
    private static int transactionId = 0;
    private MachineId machineId;
    private FcsServiceId serviceId;
    private Socket sock;
    private ObjectOutputStream out = null;
    private ObjectInputStream in = null;
    private Map pendingRequests = new HashMap();
    private Map chatlets = new HashMap();
    private ReceiverThread receiver = null;
    private Object lock = new Object();
    static /* synthetic */ Class class$com$ibm$hwmca$fw$fcs$chatlet$ChatletClientManager;

    private static synchronized int getTransactionId() {
        return transactionId++;
    }

    public static synchronized ChatletClientManager getChatletClientManager(MachineId machineId) {
        if (!clients.containsKey(machineId)) {
            clients.put(machineId, new ChatletClientManager(machineId, new FcsServiceId("FcsChatletService", 1.0)));
        }
        return (ChatletClientManager)clients.get(machineId);
    }

    synchronized void checkAllManagersForClient(ChatletClient chatletClient) throws IllegalArgumentException {
        Iterator iterator = clients.values().iterator();
        while (iterator.hasNext()) {
            ((ChatletClientManager)iterator.next()).checkForClient(chatletClient);
        }
    }

    private ChatletClientManager(MachineId machineId, FcsServiceId serviceId) {
        Trace.trace(TRACE_MASKF, "-> ChatletClientManager <ctor>");
        this.machineId = machineId;
        this.serviceId = serviceId;
        Trace.trace(TRACE_MASKF, "<- ChatletClientManager <ctor>");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void connect() throws IOException, FcsException {
        Trace.trace(TRACE_MASKF, "-> connect()");
        Object object = this.lock;
        synchronized (object) {
            if (this.receiver == null) {
                Trace.trace(TRACE_MASKF, "connecting...");
                FcsConnection connection = FcsConnection.connect(this.machineId, this.serviceId);
                Trace.trace(TRACE_MASKF, "... back, getting socket and forming streams");
                this.sock = connection.getSocket();
                this.sock.setSoTimeout(0);
                this.out = new ObjectOutputStream(new BufferedOutputStream(this.sock.getOutputStream()));
                this.out.flush();
                this.in = new ObjectInputStream(new BufferedInputStream(this.sock.getInputStream()));
                Trace.trace(TRACE_MASKF, "starting receiver thread");
                this.receiver = new ReceiverThread(this);
                this.receiver.setName("Chatlet Client receiver (" + this.machineId + ")");
                this.receiver.start();
            } else {
                Trace.trace(TRACE_MASKF, "already connected");
            }
        }
        Trace.trace(TRACE_MASKF, "<- connect()");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ChatletResponse sendRequest(ChatletRequest chatletRequest, int timeout) throws ChatletException {
        chatletRequest.setTransactionId(ChatletClientManager.getTransactionId());
        Trace.trace(TRACE_MASKF, "-> sendRequest(" + chatletRequest + ")");
        if (this.receiver != null) {
            Integer requestKey = new Integer(chatletRequest.getTransactionId());
            try {
                Object object = this.lock;
                synchronized (object) {
                    this.pendingRequests.put(requestKey, chatletRequest);
                    this.out.reset();
                    chatletRequest.writeToStream(this.out);
                    this.out.flush();
                }
                Trace.trace(TRACE_MASKF, "blocking waiting for response...");
                ChatletResponse response = chatletRequest.blockForResponse(timeout);
                Trace.trace(TRACE_MASKF, "<- sendRequest()");
                return response;
            }
            catch (ChatletRequestTimeoutException e) {
                Trace.trace(TRACE_MASKF, "Caught ChatletRequestTimeoutExcption, removing request (creating orphan)");
                Object object = this.lock;
                synchronized (object) {
                    this.pendingRequests.remove(requestKey);
                }
                throw e;
            }
            catch (ChatletException e) {
                Trace.trace(TRACE_MASKF, "Caught ChatletExcption, probably IOException while blocked, cleaning up.");
                this.terminate();
                throw e;
            }
            catch (IOException e) {
                Trace.trace(TRACE_MASKF, "Caught IOExcption, cleaning up.");
                this.terminate();
                throw new ChatletException(e);
            }
        }
        Trace.trace(TRACE_MASKF, "manager is shutdown, ignoring send request.");
        throw new ChatletException("Manager is shutdown, send rejected");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerChatlet(ChatletClient chatletClient) throws ChatletException {
        ChatletClientPortal chatletClientPortal;
        Trace.trace(TRACE_MASKF, "-> registerChatlet()");
        this.checkAllManagersForClient(chatletClient);
        ChatletException exception = null;
        Object object = this.lock;
        synchronized (object) {
            chatletClientPortal = new ChatletClientPortal(this, chatletClient);
            ChatletStruct chatletStruct = new ChatletStruct(chatletClient, chatletClientPortal);
            this.chatlets.put(chatletClient, chatletStruct);
            this.chatlets.put(new Integer(chatletClientPortal.getChatletId()), chatletStruct);
            try {
                this.connect();
            }
            catch (IOException e) {
                Trace.trace(TRACE_MASKF, "IOException while connecting, rethrowing as ChatletException");
                exception = new ChatletException(e);
            }
            catch (FcsException e) {
                Trace.trace(TRACE_MASKF, "FcsException while connecting, rethrowing as ChatletException");
                exception = new ChatletException(e);
            }
        }
        if (exception != null) {
            this.terminate();
            throw exception;
        }
        chatletClientPortal.flowInitialRequest();
        chatletClient.setChatletClientPortal(chatletClientPortal);
        Trace.trace(TRACE_MASKF, "<- registerChatlet()");
    }

    void checkForClient(ChatletClient chatletClient) throws IllegalArgumentException {
        if (this.chatlets.containsKey(chatletClient)) {
            throw new IllegalArgumentException("Passed chatlet client already appears registered with a manager");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void deregisterChatlet(ChatletClient chatletClient) throws ChatletException {
        block12: {
            Trace.trace(TRACE_MASKF, "-> deregisterChatlet()");
            try {
                ChatletStruct chatletStruct = null;
                Object object = this.lock;
                synchronized (object) {
                    if (!this.chatlets.containsKey(chatletClient)) {
                        throw new IllegalArgumentException("No such chatlet client registered");
                    }
                    chatletStruct = (ChatletStruct)this.chatlets.remove(chatletClient);
                    this.chatlets.remove(new Integer(chatletStruct.chatletClientPortal.getChatletId()));
                }
                try {
                    chatletStruct.chatletClientPortal.terminate();
                }
                catch (Exception exception) {
                }
                finally {
                    chatletStruct.chatletClient.setChatletClientPortal(null);
                }
                Object var7_6 = null;
                if (!this.chatlets.isEmpty()) break block12;
            }
            catch (Throwable throwable) {
                Object var7_7 = null;
                if (this.chatlets.isEmpty()) {
                    Trace.trace(TRACE_MASKF, "no chatlets now exist, doing terminate on this manager.");
                    this.terminate();
                }
                throw throwable;
            }
            Trace.trace(TRACE_MASKF, "no chatlets now exist, doing terminate on this manager.");
            this.terminate();
        }
        Trace.trace(TRACE_MASKF, "<- deregisterChatlet()");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void terminate() {
        Trace.trace(TRACE_MASKF, "-> terminate()");
        Map clonedPendingRequests = Collections.EMPTY_MAP;
        Map clonedChatlets = Collections.EMPTY_MAP;
        Object object = this.lock;
        synchronized (object) {
            if (!this.pendingRequests.isEmpty()) {
                clonedPendingRequests = (Map)((HashMap)this.pendingRequests).clone();
                this.pendingRequests.clear();
            }
            if (!this.chatlets.isEmpty()) {
                clonedChatlets = (Map)((HashMap)this.chatlets).clone();
                this.chatlets.clear();
            }
            if (this.receiver != null) {
                this.receiver.terminate();
                this.receiver = null;
            }
            try {
                Object var6_4;
                try {
                    this.sock.close();
                }
                catch (Exception e) {
                    var6_4 = null;
                    this.sock = null;
                    this.in = null;
                    this.out = null;
                }
                var6_4 = null;
                this.sock = null;
                this.in = null;
                this.out = null;
            }
            catch (Throwable throwable) {
                Object var6_5 = null;
                this.sock = null;
                this.in = null;
                this.out = null;
                throw throwable;
            }
        }
        Iterator iterator = clonedPendingRequests.values().iterator();
        while (iterator.hasNext()) {
            ((ChatletRequest)iterator.next()).destroy();
        }
        iterator = clonedChatlets.values().iterator();
        while (iterator.hasNext()) {
            ChatletStruct chatlet = (ChatletStruct)iterator.next();
            if (chatlet.chatletClientPortal == null) continue;
            try {
                chatlet.chatletClientPortal.terminate();
            }
            catch (Exception e) {}
            continue;
            finally {
                chatlet.chatletClientPortal = null;
            }
        }
        Trace.trace(TRACE_MASKF, "<- terminate()");
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        FcsServer.getFcsServer().addFcsEventListener(new FcsEventListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void fcsStateChanged(FcsEvent event) {
                MachineId oldId = event.getOldMachineId();
                if (event.getEventType() == 1 && event.getEventDetails() == 54) {
                    Class clazz = class$com$ibm$hwmca$fw$fcs$chatlet$ChatletClientManager == null ? (class$com$ibm$hwmca$fw$fcs$chatlet$ChatletClientManager = ChatletClientManager.class$("com.ibm.hwmca.fw.fcs.chatlet.ChatletClientManager")) : class$com$ibm$hwmca$fw$fcs$chatlet$ChatletClientManager;
                    synchronized (clazz) {
                        if (clients.containsKey(oldId)) {
                            clients.put(event.getMachineId(), clients.remove(oldId));
                        }
                    }
                }
            }
        });
    }

    static class ReceiverThread
    extends Thread {
        ChatletClientManager manager = null;
        boolean terminate = false;

        ReceiverThread(ChatletClientManager manager) {
            this.manager = manager;
        }

        void terminate() {
            this.terminate = true;
            this.manager = null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Trace.trace(ChatletClientManager.TRACE_MASKF, "Receiver thread starts");
            while (!this.terminate) {
                try {
                    Trace.trace(ChatletClientManager.TRACE_MASKF, "Chatlet client receiver puts up read...");
                    ChatletPacket packet = ChatletObjectFactory.readResponse(this.manager.in);
                    Trace.trace(ChatletClientManager.TRACE_MASKF, "Chatlet client receiver receives: " + packet);
                    if (packet instanceof ChatletMessage) {
                        Trace.trace(ChatletClientManager.TRACE_MASKF, "deemed ChatletMessage");
                        Object object = this.manager.lock;
                        synchronized (object) {
                            if (!this.terminate) {
                                ChatletStruct sStruct = (ChatletStruct)this.manager.chatlets.get(new Integer(packet.chatletId));
                                if (sStruct == null) {
                                    Trace.trace(ChatletClientManager.TRACE_MASKF, "Warning! inbound object for unknown chatlet entity, ignored");
                                } else {
                                    new Thread(this, "Chatlet Async Message driver", sStruct, packet){
                                        private final /* synthetic */ ChatletStruct val$sStruct;
                                        private final /* synthetic */ ChatletPacket val$packet;
                                        private final /* synthetic */ ReceiverThread this$0;
                                        {
                                            this.this$0 = this$0;
                                            this.val$sStruct = val$sStruct;
                                            this.val$packet = val$packet;
                                        }

                                        public void run() {
                                            Trace.trace("XFCS-CMF", "deemed ChatletMessage");
                                            this.val$sStruct.chatletClient.asynchronousMessage((ChatletMessage)this.val$packet);
                                        }
                                    }.start();
                                }
                            } else {
                                break;
                            }
                            continue;
                        }
                    }
                    if (packet instanceof ChatletResponse) {
                        Trace.trace(ChatletClientManager.TRACE_MASKF, "deemed ChatletResponse");
                        ChatletRequest request = null;
                        Object object = this.manager.lock;
                        synchronized (object) {
                            if (this.terminate) {
                                break;
                            }
                            request = (ChatletRequest)this.manager.pendingRequests.remove(new Integer(packet.transactionId));
                        }
                        if (request == null) {
                            Trace.trace(ChatletClientManager.TRACE_MASKF, "Warning! response for unknown request, ignored (possible orphan from request timeout)");
                            continue;
                        }
                        Trace.trace(ChatletClientManager.TRACE_MASKF, "driving request with response");
                        request.postResponse((ChatletResponse)packet);
                        continue;
                    }
                    Trace.trace(ChatletClientManager.TRACE_MASKF, "Warning! inbound object wasn't a message or response, ignored");
                }
                catch (Exception e) {
                    Trace.trace(ChatletClientManager.TRACE_MASKF, "Chatlet client receiver catches exception (perhaps during termination processing), cleaning up.");
                    Trace.trace(ChatletClientManager.TRACE_MASKF, e);
                    if (this.manager == null) continue;
                    this.manager.terminate();
                }
            }
            Trace.trace(ChatletClientManager.TRACE_MASKF, "Client receiver thread ends");
        }
    }

    static class ChatletStruct {
        ChatletClient chatletClient;
        ChatletClientPortal chatletClientPortal;

        ChatletStruct(ChatletClient chatletClient, ChatletClientPortal chatletClientPortal) {
            this.chatletClient = chatletClient;
            this.chatletClientPortal = chatletClientPortal;
        }
    }
}

